<?php
session_start();

if (isset($_POST['logout'])) {
  session_destroy();
  header("Location: login.php");
  exit;
}

if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Crear usuario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['crear'])) {
  $nombre = trim($_POST['nombre']);
  $correo = trim($_POST['correo']);
  $clave = $_POST['clave'];
  $rol = $_POST['rol'];
  $region = $_POST['region'];
  $estado = $_POST['estado'];

  $stmt = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE correo = ?");
  $stmt->execute([$correo]);
  $existe = $stmt->fetchColumn();

  if ($existe > 0) {
    $mensaje_error = "⚠️ El correo ya está registrado.";
  } else {
    $clave_segura = password_hash($clave, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO usuarios (nombre, correo, clave, clave_visible, rol, region, estado) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$nombre, $correo, $clave_segura, $clave, $rol, $region, $estado]);
    $mensaje_exito = "✅ Usuario creado correctamente.";
  }
}

// Modificar usuario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['modificar'])) {
  $id            = intval($_POST['id']);
  $nombre        = $_POST['nombre'];
  $correo        = $_POST['correo'];
  $rol           = $_POST['rol'];
  $region        = $_POST['region'];
  $estado        = $_POST['estado'];
  $clave_visible = $_POST['clave_visible'] ?? '';

  $stmt = $pdo->prepare("SELECT correo FROM usuarios WHERE id = ?");
  $stmt->execute([$id]);
  $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($usuario && $usuario['correo'] === 'alonso.reyes@grupoblmg.com') {
    $mensaje_error = "⚠️ Este usuario está protegido y no puede ser modificado.";
  } else {
    $stmt = $pdo->prepare("UPDATE usuarios SET nombre = ?, correo = ?, rol = ?, region = ?, estado = ?, clave_visible = ? WHERE id = ?");
    $stmt->execute([$nombre, $correo, $rol, $region, $estado, $clave_visible, $id]);
    $mensaje_exito = "✅ Usuario actualizado correctamente.";
  }
}

// Eliminar usuario
if (isset($_GET['eliminar'])) {
  $id = intval($_GET['eliminar']);
  $stmt = $pdo->prepare("SELECT correo FROM usuarios WHERE id = ?");
  $stmt->execute([$id]);
  $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($usuario && $usuario['correo'] !== 'alonso.reyes@grupoblmg.com') {
    $pdo->prepare("DELETE FROM usuarios WHERE id = ?")->execute([$id]);
  }
}

$usuarios = $pdo->query("SELECT id, nombre, correo, clave_visible, rol, region, estado FROM usuarios ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>🔐 Panel de Administración</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: Arial, sans-serif; background-color: #f9f9f9; margin: 0; padding: 30px; }
    .top-bar { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
    .volver-btn, .logout-form button {
      padding: 10px 20px; font-size: 14px; border: none; border-radius: 6px; cursor: pointer; color: white;
    }
    .volver-btn { background-color: #343a40; text-decoration: none; }
    .volver-btn:hover { background-color: #23272b; }
    .logout-form button { background-color: #dc3545; }
    .logout-form button:hover { background-color: #c82333; }
    h2 { margin-bottom: 20px; color: #333; }
    form, table {
      background: #fff; padding: 15px; border-radius: 8px;
      box-shadow: 0 0 5px rgba(0,0,0,0.1); margin-bottom: 30px;
    }
    input, select, button {
      margin: 5px 0; padding: 8px; font-size: 14px; width: 100%; box-sizing: border-box;
    }
    table { width: 100%; border-collapse: collapse; }
    th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
    th { background-color: #f1f1f1; }
    .protegido { color: #888; font-weight: bold; }
    .eliminar { color: red; text-decoration: none; margin-left: 10px; }
    .guardar-btn { background-color: #007bff; color: white; border: none; padding: 6px 10px; border-radius: 4px; cursor: pointer; }
    .guardar-btn:disabled { background-color: #ccc; cursor: not-allowed; }
    .mensaje { font-weight: bold; margin-bottom: 15px; }
    
    .cerrar-btn {
  background-color: #dc3545;
  color: white;
  padding: 10px 20px;
  font-size: 14px;
  border-radius: 6px;
  text-decoration: none;
  display: inline-block;
}

.cerrar-btn:hover {
  background-color: #c82333;
}

    
  </style>
</head>
<body>

  <div class="top-bar">
    <a href="admin_home.php" class="volver-btn">⬅️ Volver al menú</a>
    <a href="logout.php" class="cerrar-btn">🔓 Cerrar sesión</a>
  </div>

  <h2>👑 Panel de Administración</h2>

  <?php if (isset($mensaje_error)): ?>
    <p class="mensaje" style="color: red;"><?= $mensaje_error ?></p>
  <?php endif ?>
  <?php if (isset($mensaje_exito)): ?>
    <p class="mensaje" style="color: green;"><?= $mensaje_exito ?></p>
  <?php endif ?>

  <h3>➕ Crear nuevo usuario</h3>
  <form method="POST">
    <input type="text" name="nombre" placeholder="Nombre completo" required>
    <input type="email" name="correo" placeholder="Correo electrónico" required>
    <input type="password" name="clave" placeholder="Contraseña" required>
    <select name="rol">
      <option value="usuario">Usuario</option>
      <option value="admin">Administrador</option>
    </select>
    <select name="region">
      <option value="lima">Lima</option>
      <option value="cusco 1">Cusco 1</option>
      <option value="cusco 2">Cusco 2</option>
      <option value="piura">Piura</option>
    </select>
    <select name="estado">
      <option value="activo">Activo</option>
      <option value="desactivado">Desactivado</option>
    </select>
    <button type="submit" name="crear">Crear usuario</button>
  </form>

  <h3>👥 Usuarios registrados</h3>
  <table>
    <thead>
      <tr>
        <th>ID</th><th>Nombre</th><th>Correo</th><th>Clave visible</th><th>Rol</th><th>Región</th><th>Estado</th><th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($usuarios as $u): ?>
        <tr>
          <form method="POST">
            <td><a href="#" class="editar-id"><?= $u['id'] ?></a><input type="hidden" name="id" value="<?= $u['id'] ?>"></td>
            <td><input type="text" name="nombre" value="<?= htmlspecialchars($u['nombre']) ?>" disabled></td>
            <td><input type="email" name="correo" value="<?= htmlspecialchars($u['correo']) ?>" disabled></td>
            <td><input type="text" name="clave_visible" value="<?= htmlspecialchars($u['clave_visible']) ?>" disabled></td>
                        <td>
              <select name="rol" disabled>
                <option value="usuario" <?= $u['rol'] === 'usuario' ? 'selected' : '' ?>>Usuario</option>
                <option value="admin" <?= $u['rol'] === 'admin' ? 'selected' : '' ?>>Administrador</option>
              </select>
            </td>
            <td>
              <select name="region" disabled>
                <option value="lima" <?= $u['region'] === 'lima' ? 'selected' : '' ?>>Lima</option>
                <option value="cusco 1" <?= $u['region'] === 'cusco 1' ? 'selected' : '' ?>>Cusco 1</option>
                <option value="cusco 2" <?= $u['region'] === 'cusco 2' ? 'selected' : '' ?>>Cusco 2</option>
                <option value="piura" <?= $u['region'] === 'piura' ? 'selected' : '' ?>>Piura</option>
              </select>
            </td>
            <td>
              <select name="estado" disabled>
                <option value="activo" <?= $u['estado'] === 'activo' ? 'selected' : '' ?>>Activo</option>
                <option value="desactivado" <?= $u['estado'] === 'desactivado' ? 'selected' : '' ?>>Desactivado</option>
              </select>
            </td>
            <td>
              <?php if ($u['correo'] === 'alonso.reyes@grupoblmg.com'): ?>
                <span class="protegido">👑 Usuario protegido</span>
              <?php else: ?>
                <button type="submit" name="modificar" class="guardar-btn" disabled>💾 Modificar</button>
                <a class="eliminar" href="?eliminar=<?= $u['id'] ?>" onclick="return confirm('¿Eliminar este usuario?')">🗑️</a>
              <?php endif ?>
            </td>
          </form>
        </tr>
      <?php endforeach ?>
    </tbody>
  </table>

  <script>
    document.querySelectorAll('.editar-id').forEach(link => {
      link.addEventListener('click', e => {
        e.preventDefault();
        const row = link.closest('tr');
        row.querySelectorAll('input, select').forEach(el => el.disabled = false);
        const boton = row.querySelector('button[name="modificar"]');
        if (boton) boton.disabled = false;
      });
    });
  </script>

</body>
</html>