<?php
session_start();
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id            = intval($_POST['id']);
  $nombre        = $_POST['nombre'];
  $correo        = $_POST['correo'];
  $rol           = $_POST['rol'];
  $region        = $_POST['region'];
  $estado        = $_POST['estado'];
  $clave_visible = $_POST['clave_visible'] ?? '';
  $nueva_clave   = trim($_POST['clave']);

  $stmt = $pdo->prepare("SELECT correo FROM usuarios WHERE id = ?");
  $stmt->execute([$id]);
  $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($usuario && $usuario['correo'] === 'alonso.reyes@grupoblmg.com') {
    $error = "⚠️ Este usuario está protegido y no puede ser modificado.";
  } else {
    if (!empty($nueva_clave)) {
      $clave_segura = password_hash($nueva_clave, PASSWORD_DEFAULT);
      $stmt = $pdo->prepare("UPDATE usuarios SET nombre = ?, correo = ?, rol = ?, region = ?, estado = ?, clave = ?, clave_visible = ? WHERE id = ?");
      $stmt->execute([$nombre, $correo, $rol, $region, $estado, $clave_segura, $nueva_clave, $id]);
    } else {
      $stmt = $pdo->prepare("UPDATE usuarios SET nombre = ?, correo = ?, rol = ?, region = ?, estado = ?, clave_visible = ? WHERE id = ?");
      $stmt->execute([$nombre, $correo, $rol, $region, $estado, $clave_visible, $id]);
    }
    $exito = "✅ Usuario actualizado correctamente.";
  }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>✏️ Editar Usuario</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      padding: 40px;
    }
    .form-box {
      background: #fff;
      padding: 25px;
      max-width: 500px;
      margin: auto;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #333;
    }
    input, select, button {
      width: 100%;
      padding: 10px;
      margin: 10px 0;
      font-size: 14px;
      box-sizing: border-box;
    }
    button {
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      cursor: pointer;
    }
    button:hover {
      background-color: #0056b3;
    }
    .mensaje {
      text-align: center;
      font-weight: bold;
      margin-top: 15px;
    }
    .volver {
      display: block;
      text-align: center;
      margin-top: 20px;
      text-decoration: none;
      color: #007bff;
    }
    .volver:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

  <div class="form-box">
    <h2>✏️ Editar Usuario</h2>
    <form method="POST">
      <input type="number" name="id" placeholder="ID del usuario" required>
      <input type="text" name="nombre" placeholder="Nombre completo" required>
      <input type="email" name="correo" placeholder="Correo electrónico" required>
      <input type="text" name="clave_visible" placeholder="Contraseña visible (actual o nueva)">
      <input type="password" name="clave" placeholder="Nueva contraseña (opcional)">
      <select name="rol" required>
        <option value="usuario">Usuario</option>
        <option value="admin">Administrador</option>
      </select>
      <select name="region" required>
        <option value="lima">Lima</option>
        <option value="cusco 1">Cusco 1</option>
        <option value="cusco 2">Cusco 2</option>
        <option value="piura">Piura</option>
      </select>
      <select name="estado" required>
        <option value="activo">Activo</option>
        <option value="desactivado">Desactivado</option>
      </select>
      <button type="submit">Guardar cambios</button>
    </form>

    <?php if (isset($error)): ?>
      <p class="mensaje" style="color: red;"><?= $error ?></p>
    <?php endif ?>
    <?php if (isset($exito)): ?>
      <p class="mensaje" style="color: green;"><?= $exito ?></p>
    <?php endif ?>

    <a href="admin.php" class="volver">⬅️ Volver al panel</a>
  </div>

</body>
</html>