<?php
session_start();
if (!isset($_SESSION['rol']) || !in_array($_SESSION['rol'], ['usuario', 'admin'])) {
  header("Location: panel_recorrido.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {
  $id = $_POST['id'];

  // 🔐 Seguridad adicional: los usuarios solo pueden eliminar sus propios recorridos
  if ($_SESSION['rol'] === 'usuario') {
    $stmt = $pdo->prepare("SELECT kam FROM recorrido WHERE id = ?");
    $stmt->execute([$id]);
    $recorrido = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$recorrido || $recorrido['kam'] !== $_SESSION['nombre']) {
      header("Location: panel_recorrido.php");
      exit;
    }
  }

  // ✅ Eliminación permitida para admin o usuario dueño
  $stmt = $pdo->prepare("DELETE FROM recorrido WHERE id = ?");
  $stmt->execute([$id]);
}

header("Location: panel_recorrido.php");
exit;
?>