<?php
session_start();
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$mensaje = "";
$confirmado = false;

if (isset($_GET['id'])) {
  $id = intval($_GET['id']);

  // Si ya se confirmó
  if (isset($_POST['confirmar']) && $_POST['confirmar'] === 'si') {
    $stmt = $pdo->prepare("SELECT correo FROM usuarios WHERE id = ?");
    $stmt->execute([$id]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($usuario && $usuario['correo'] === 'alonso.reyes@grupoblmg.com') {
      $mensaje = "⚠️ Este usuario está protegido y no puede ser eliminado.";
    } else {
      $pdo->prepare("DELETE FROM usuarios WHERE id = ?")->execute([$id]);
      $mensaje = "✅ Usuario eliminado correctamente.";
    }
    $confirmado = true;
  }

  // Si se canceló
  if (isset($_POST['confirmar']) && $_POST['confirmar'] === 'no') {
    header("Location: admin.php");
    exit;
  }
} else {
  $mensaje = "⚠️ No se recibió un ID válido.";
  $confirmado = true;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>🗑️ Eliminar Usuario</title>
  <style>
    body { font-family: Arial; background: #f4f4f4; padding: 40px; text-align: center; }
    .mensaje { font-weight: bold; margin-top: 20px; }
    .botones form { display: inline-block; margin: 10px; }
    .botones button {
      padding: 10px 20px;
      font-size: 16px;
      border: none;
      border-radius: 6px;
      cursor: pointer;
    }
    .si { background-color: #dc3545; color: white; }
    .no { background-color: #6c757d; color: white; }
    .volver {
      display: block;
      margin-top: 30px;
      text-decoration: none;
      color: #007bff;
    }
  </style>
</head>
<body>

  <h2>🗑️ Eliminar Usuario</h2>

  <?php if (!$confirmado): ?>
    <p class="mensaje">¿Estás seguro de que deseas eliminar al usuario con ID <strong><?= $id ?></strong>?</p>
    <div class="botones">
      <form method="POST">
        <input type="hidden" name="confirmar" value="si">
        <button type="submit" class="si">✅ Sí, eliminar</button>
      </form>
      <form method="POST">
        <input type="hidden" name="confirmar" value="no">
        <button type="submit" class="no">❌ No, cancelar</button>
      </form>
    </div>
  <?php else: ?>
    <p class="mensaje"><?= $mensaje ?></p>
    <a href="admin.php" class="volver">⬅️ Volver al panel</a>
  <?php endif ?>

</body>
</html>